document.addEventListener('contextmenu', event => event.preventDefault());

function setup() {
    const canvas = createCanvas(windowWidth - 300, windowHeight);
    canvas.parent('sketch');
    strokeWeight(5);

    globals.elementCreator.elementManager = globals.elementManager;

    const elasticitySlider = select('#elasticity');
    elasticitySlider.mouseMoved(changeElasticity);

    const transparent = select('#type');
    transparent.mouseClicked(changeTransparency);
}

function draw() { 
    background(255);
    globals.elementManager.draw(0);
    globals.elementCreator.draw(0);
    globals.cursor.draw(128);
}

function calculate() {
    for (let i = 0; i < globals.balls.length; i++) {
        const ball = globals.balls[i];
        if (ball.physics) {
            const gravity = new Vector(0, 0.01);
            ball.applyForce(gravity);

            const collisions = globals.elementManager.collision(ball.position.x,ball.position.y, 12, ball);

            if (collisions) {
                for (collision of collisions) {
                    ball.applyImpulse(collision);
                }
            }

            ball.resolve();
        }
    }
}

setInterval(calculate, 1);
