function windowResized() {
    resizeCanvas(windowWidth - 300, windowHeight);
}

function mousePressed() {
    if (!onCanvas()) {
        return;
    }
    if (mouseButton == LEFT) {
        globals.elementCreator.mousePressed();
        globals.cursor.active = true;
    }
    if (mouseButton == RIGHT) {
        const ball = new PhysicsObject(globals.stats.solid, globals.stats.conservation);
        globals.balls.push(ball);
        globals.elementManager.add(ball);
        ball.reset(mouseX, mouseY);
    }
}

function mouseReleased() {
    globals.elementCreator.mouseReleased();
    globals.cursor.active = false;
    if (mouseButton == RIGHT) {
        globals.balls[globals.balls.length - 1].begin();
    }
}

function mouseDragged() {
    if (!onCanvas()) {
        return;
    }
    globals.elementCreator.mouseDragged();
    globals.cursor.mouseMoved();
}

function mouseMoved() {
    if (!onCanvas()) {
        return;
    }
    globals.cursor.mouseMoved();
}
